/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.AbortThread;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.HandlerManager;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.PrepareMsg;
import com.ibm.hwmca.fw.rbf.impl.PrepareReply;
import com.ibm.hwmca.fw.rbf.impl.QueryTask;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.ResultReporter;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

class HandlerPreparer {
    private static final String TRACE_MASKT = "XRBFHPRT";
    private static final String TRACE_MASKF = "XRBFHPRF";
    private static final String TRACE_MASKD = "XRBFHPRD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-HndlPrep");
    private static LinkedList queue = new LinkedList();
    private static List preparers = new ArrayList();
    private static Object preparersLock = new Object();
    private static final int PREPARERS_MAX = 15;
    private static final long PREPARER_TIMEOUT = 120000L;
    private static final int QUEUE_BACKLOG_PER_THREAD = 2;
    private static final int PREPARE_MSG_TIMEOUT = 180000;
    private static FcsServer fcsServer = FcsServer.getFcsServer();
    private static Random random = new Random();

    private HandlerPreparer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void prepareHandlers(RbfRequest request) {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> prepareHandlers() " + requestId);
        Object object = preparersLock;
        synchronized (object) {
            if (!queue.contains(request)) {
                queue.add(request);
                Trace.trace(TRACE_MASKD, HandlerPreparer.getQueueDump());
            }
            Trace.trace(TRACE_MASKF, queue.size() + " requests in the handler " + "preparer queue");
            int active = preparers.size();
            if (active < 15 && queue.size() > 2 * active) {
                Preparer preparer = new Preparer(new Date().toString());
                preparer.start();
                preparers.add(preparer);
            }
            Trace.trace(TRACE_MASKF, preparers.size() + " preparer threads in existence");
            preparersLock.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- prepareHandlers() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getQueueDump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Handler preparer queue:\n");
        Object object = preparersLock;
        synchronized (object) {
            if (queue.isEmpty()) {
                sb.append("1. Empty");
            } else {
                int index = 1;
                Iterator iterator = queue.iterator();
                while (iterator.hasNext()) {
                    RbfRequest request = (RbfRequest)iterator.next();
                    if (index == 1) {
                        sb.append(index + ". " + request.getIdentifier());
                    } else {
                        sb.append("\n" + index + ". " + request.getIdentifier());
                    }
                    ++index;
                }
            }
        }
        return sb.toString();
    }

    private static class Preparer
    extends Thread {
        String id;
        boolean inactive = false;

        Preparer(String id) {
            super("RBF Handler Preparer " + id);
            this.id = id;
            Trace.trace(HandlerPreparer.TRACE_MASKT, "<> Preparer " + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Trace.trace(HandlerPreparer.TRACE_MASKT, "-> Preparer " + this.id + " running");
                HandlerManager.getHandlerManager().waitUntilInitialized();
                while (!this.inactive) {
                    RbfRequest nextRequest = null;
                    long waitBegins = System.currentTimeMillis();
                    long timeToWait = 120000L;
                    Object object = preparersLock;
                    synchronized (object) {
                        while (queue.size() <= 0 && timeToWait > 0L) {
                            try {
                                preparersLock.wait(timeToWait);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            timeToWait = 120000L - (System.currentTimeMillis() - waitBegins);
                        }
                        if (queue.size() > 0) {
                            nextRequest = (RbfRequest)queue.removeFirst();
                        } else {
                            preparers.remove(this);
                            this.inactive = true;
                        }
                    }
                    if (nextRequest == null) continue;
                    this.prepareFor(nextRequest);
                }
                Trace.trace(HandlerPreparer.TRACE_MASKT, "<- Preparer " + this.id + " ending due to inactivity");
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                this.getThreadGroup().uncaughtException(this, throwable);
                Object object = preparersLock;
                synchronized (object) {
                    preparers.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareFor(RbfRequest request) {
            RequestTrackingData trackingData = request.getTrackingData();
            PrepareMsg prepareMsg = null;
            PrepareReply prepareReply = null;
            MachineId nextToPrepare = null;
            Trace.trace(HandlerPreparer.TRACE_MASKF, "Checking preparations: " + request.toDebugString());
            boolean finished = false;
            while (!finished) {
                RequestTrackingData requestTrackingData = trackingData;
                synchronized (requestTrackingData) {
                    if (trackingData.isHandlerNeeded()) {
                        nextToPrepare = this.getNextToPrepare(request);
                        if (nextToPrepare == null) {
                            String desc = "No machines remaining to prepare";
                            Trace.trace(HandlerPreparer.TRACE_MASKF, desc);
                            if (!trackingData.isAnyPreparation() && !trackingData.isAnyAborting()) {
                                this.findResultAndClose(request);
                            }
                            finished = true;
                        } else {
                            if (prepareMsg == null && (prepareMsg = this.createPrepareMsg(request)) == null) {
                                finished = true;
                            }
                            if (!finished) {
                                trackingData.addAskingToPrepare(nextToPrepare);
                            }
                        }
                    } else {
                        Trace.trace(HandlerPreparer.TRACE_MASKF, "Request no longer requires a handler");
                        finished = true;
                    }
                }
                if (finished) continue;
                Date originalBoot = fcsServer.getBootTime(nextToPrepare);
                boolean abort = false;
                prepareReply = this.sendPrepareMsg(prepareMsg, nextToPrepare, request);
                RequestTrackingData requestTrackingData2 = trackingData;
                synchronized (requestTrackingData2) {
                    trackingData.removeAskingToPrepare(nextToPrepare);
                    if (!this.isBootChanged(nextToPrepare, originalBoot)) {
                        if (trackingData.isHandlerNeeded()) {
                            if (prepareReply != null) {
                                int prepareReplyStatus = prepareReply.getStatus();
                                if (!prepareReply.isValidStatus(prepareReplyStatus)) {
                                    trackingData.addUnusable(nextToPrepare);
                                    String desc = "Internal error: Invalid prepare reply status (" + prepareReplyStatus + ") received from " + RbfUtils.getMachineInfo(nextToPrepare) + request.getIdentifier();
                                    Trace.trace(HandlerPreparer.TRACE_MASKF, desc);
                                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                                    fl.add(desc);
                                    fl.add(RbfUtils.getLoggingInfo(request));
                                    fl.log();
                                    trackingData.errorResultCode = 8;
                                    trackingData.errorDetail = new RbfErrorDetail(1060, desc);
                                } else if (prepareReply.isPreparing()) {
                                    if (!trackingData.isUnusable(nextToPrepare)) {
                                        trackingData.addPreparing(nextToPrepare);
                                        if (trackingData.queryTask == null) {
                                            QueryTask queryTask;
                                            trackingData.queryTask = queryTask = new QueryTask(request.getIdentifier());
                                            Timer queryTimer = QueryTask.getTimer();
                                            queryTimer.schedule((TimerTask)queryTask, 300000L, 300000L);
                                        }
                                    }
                                } else if (prepareReply.isError()) {
                                    trackingData.addUnusable(nextToPrepare);
                                    trackingData.errorResultCode = prepareReply.getErrorResultCode();
                                    trackingData.errorDetail = prepareReply.getErrorDetail();
                                } else if (prepareReply.isBusy()) {
                                    trackingData.addBusy(nextToPrepare);
                                } else {
                                    trackingData.addUnusable(nextToPrepare);
                                }
                            } else {
                                trackingData.addUnusable(nextToPrepare);
                            }
                        } else if (prepareReply != null && prepareReply.isPreparing() && trackingData.handler != null && !trackingData.handler.equals(nextToPrepare)) {
                            trackingData.addAborting(nextToPrepare);
                            AbortThread at = null;
                            at = trackingData.canceled ? new AbortThread(request, nextToPrepare, 4) : new AbortThread(request, nextToPrepare, 0);
                            at.start();
                        }
                    }
                }
            }
        }

        private MachineId getNextToPrepare(RbfRequest request) {
            RequestTrackingData trackingData = request.getTrackingData();
            ArrayList potential = new ArrayList();
            int scope = request.getScope();
            if (scope == 2) {
                if (trackingData.handlerSubset != null) {
                    potential.addAll(trackingData.handlerSubset);
                }
            } else {
                HandlerManager handlerMgr = HandlerManager.getHandlerManager();
                potential.addAll(handlerMgr.getHandlingMachines(request.getType(), scope));
            }
            if (trackingData.askingToPrepare != null) {
                potential.removeAll(trackingData.askingToPrepare);
            }
            if (trackingData.preparing != null) {
                potential.removeAll(trackingData.preparing);
            }
            if (trackingData.busy != null) {
                potential.removeAll(trackingData.busy);
            }
            if (trackingData.aborting != null) {
                potential.removeAll(trackingData.aborting);
            }
            if (trackingData.unusable != null) {
                potential.removeAll(trackingData.unusable);
            }
            if (potential.isEmpty()) {
                Trace.trace(HandlerPreparer.TRACE_MASKF, "Potential: None");
                return null;
            }
            Trace.trace(HandlerPreparer.TRACE_MASKF, "Potential: " + RbfUtils.getMachineInfo(potential));
            MachineId localMachine = fcsServer.getLocalMachineId();
            if (potential.contains(localMachine)) {
                return localMachine;
            }
            return (MachineId)potential.get(random.nextInt(potential.size()));
        }

        private PrepareMsg createPrepareMsg(RbfRequest request) {
            try {
                return new PrepareMsg(request);
            }
            catch (PersistenceException pe) {
                String desc = pe.getClass().getName() + " encoding " + request.getClass().getName() + ":\n" + RbfUtils.getStackTrace(pe);
                RbfErrorDetail detail = new RbfErrorDetail(1056, desc);
                ResultReporter.reportAndClose(request, 4, detail);
                return null;
            }
        }

        private PrepareReply sendPrepareMsg(PrepareMsg msg, MachineId target, RbfRequest request) {
            try {
                CommManager commMgr = CommManager.getCommManager();
                RbfReply reply = commMgr.send(msg, target, 180000);
                if (reply instanceof PrepareReply) {
                    return (PrepareReply)reply;
                }
                String desc = "Internal error: Invalid prepare reply (" + reply.getClass().getName() + ") received from " + RbfUtils.getMachineInfo(target) + " " + request.getIdentifier();
                Trace.trace(HandlerPreparer.TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(request));
                fl.log();
                return null;
            }
            catch (RbfException rbfe) {
                return null;
            }
        }

        private boolean isBootChanged(MachineId target, Date boot) {
            Date currentBoot = fcsServer.getBootTime(target);
            if (boot == null) {
                return currentBoot != null;
            }
            return !boot.equals(currentBoot);
        }

        private void findResultAndClose(RbfRequest request) {
            RequestTrackingData trackingData = request.getTrackingData();
            if (trackingData.redrive) {
                RbfHandleResponse response = null;
                try {
                    RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                    response = rhMgr.getHandleResponse(request.getIdentifier());
                }
                catch (PersistenceNotInitializedException pnie) {
                    // empty catch block
                }
                if (response != null) {
                    ResultReporter.reportAndClose(request, 28, response.getDetails());
                } else if (trackingData.errorDetail != null) {
                    ResultReporter.reportAndClose(request, trackingData.errorResultCode, trackingData.errorDetail);
                } else {
                    String desc = "Internal error: Insufficient data: Redrive flag true without a handle response or error detail available";
                    RbfErrorDetail detail = new RbfErrorDetail(1060, desc);
                    ResultReporter.reportAndClose(request, 8, detail);
                }
            } else if (trackingData.handlerOutage) {
                ResultReporter.reportAndClose(request, 32, null);
            } else if (trackingData.notCapableOffer) {
                ResultReporter.reportAndClose(request, 20, null);
            } else if (trackingData.isAnyBusy()) {
                ResultReporter.reportAndClose(request, 2, null);
            } else if (trackingData.errorDetail != null) {
                ResultReporter.reportAndClose(request, trackingData.errorResultCode, trackingData.errorDetail);
            } else {
                ResultReporter.reportAndClose(request, 16, null);
            }
        }
    }
}

